//
//  ABAddressBook+BIAdditions.h
//  BISubstrate
//
//  Created by Ali Lalani on 27/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AddressBook/AddressBook.h>

/*!
    @header ABAddressBook+BIAdditions
    @abstract   This is a category added to ABAddressBook which just adds accessibility methods which we commonly use in Billings.
    @discussion Methods in this category just help us with commonly used methods which we need to do in Billings.  Majority of the methods deal with adding ABPersons to the AddressBook given first, last names, etc. Also, we have methods which allow us to add ABPersons to the Billings Group, a shortcut to the Billings group and querying functionality to find ABPersons matching some criteria.
*/


@interface ABAddressBook (BIAdditions)

- (ABPerson*)createABPersonWithCompanyName:(NSString*)aName
                                     email:(NSString*)emailAddr;

- (ABPerson*)createABPersonWithCompanyName:(NSString*)aName
                                     email:(NSString*)emailAddr
                               performSave:(BOOL)shouldSave;

- (ABPerson*)createABPersonWithFirstname:(NSString*)fname 
                                lastname:(NSString*)lname
                                   email:(NSString*)emailAddr
                                 company:(NSString*)company;

- (ABPerson*)createABPersonWithFirstname:(NSString*)fname 
                                lastname:(NSString*)lname
                                   email:(NSString*)emailAddr
                                 company:(NSString*)company
                             performSave:(BOOL)shouldSave;

- (ABPerson*)abPersonWithABUID:(NSString*)anABUID
                     firstname:(NSString*)fname
                      lastname:(NSString*)lname
                         email:(NSString*)emailAddr
                       company:(NSString*)company;

@end
